#include <QtGui>

 #include "IntroModeSelectDlg.h"
 #include "mode1/DrawERDlg.h"
 #include "mode2/PropertyClassDlg.h"
 #include "mode3/DirectQueryDlg.h"

 #define MESSAGE \
     IntroModeSelectDlg::tr("<p>Message boxes have a caption, a text, " \
                "and any number of buttons, each with standard or custom texts." \
                "<p>Click a button to close the message box. Pressing the Esc button " \
                "will activate the detected escape button (if any).")

 IntroModeSelectDlg::IntroModeSelectDlg(QWidget *parent)
     : QDialog(parent)
 {
	QFont titleFont("", 13, QFont::Bold);
	QFont labelFont("",10);
	QFont mostFont("",11);
	setFont(mostFont);
	logoImageLabel = new QLabel;
	//QString fileName = tr("images/MainTitle.png");
	QImage logoImage(tr("images/MainTitle.png"));
	logoImageLabel->setPixmap(QPixmap::fromImage(logoImage));
	//logoImageLabel->setGeometry(0,0,100,300);

	titleLabel = new QLabel(tr("ͺ̽ ̺   "));
	titleLabel->setFont(titleFont);
    label = new QLabel(tr("   ̺   ݴϴ. \n"
                          "Ʒ ϴ  ̺ Ͻʽÿ."));
	label->setFont(labelFont);

    qwizardCtorRadioButton = new QRadioButton(tr(" ̺ "));
    qtableCtorRadioButton = new QRadioButton(tr("̺ Ӽ "));
    defaultCtorRadioButton = new QRadioButton(tr(" ̺ "));

    qwizardCtorRadioButton->setChecked(true);
	
	nextBtn = new QPushButton(tr(""));
	cancelBtn = new QPushButton(tr(""));

	connect(nextBtn, SIGNAL(clicked()), this, SLOT(clickNext()));
	connect(cancelBtn, SIGNAL(clicked()), this, SLOT(clickCancel()));

	QVBoxLayout *labelLayout = new QVBoxLayout;
	labelLayout->addSpacing(5);
	labelLayout->addWidget(titleLabel);
	labelLayout->addWidget(label);
	labelLayout->setMargin(0);
	labelLayout->setAlignment(Qt::AlignTop | Qt::AlignLeft);

	QVBoxLayout *radioBtnLayout = new QVBoxLayout;
	radioBtnLayout->addWidget(qwizardCtorRadioButton);
	radioBtnLayout->addWidget(qtableCtorRadioButton);
	radioBtnLayout->addWidget(defaultCtorRadioButton);
	radioBtnLayout->setAlignment(Qt::AlignCenter);

	QHBoxLayout * btnLayout = new QHBoxLayout;
	btnLayout->addWidget(nextBtn);
	btnLayout->addWidget(cancelBtn);
	btnLayout->setAlignment(Qt::AlignBottom | Qt::AlignRight);

    QVBoxLayout *introBoxLayout = new QVBoxLayout;
	introBoxLayout->addLayout(labelLayout);
    introBoxLayout->addLayout(radioBtnLayout);
	introBoxLayout->addLayout(btnLayout);

	QHBoxLayout * mainLayout = new QHBoxLayout;
	mainLayout->addWidget(logoImageLabel);
	mainLayout->addLayout(introBoxLayout);
    setLayout(mainLayout);
	
	//setGeometry(100,100,500,300);

    setWindowTitle(tr("ͺ̽ ̺ "));
 }

 void IntroModeSelectDlg::clickNext()
 {
	 accept ();

	 if (qwizardCtorRadioButton->isChecked()) 
	 {		 
		DrawERDlg* erTable = new DrawERDlg();
		erTable->exec();				
     } 
	 else if(qtableCtorRadioButton->isChecked())
	 {
		PropertyClassDlg *propertyDlg = new PropertyClassDlg();
		propertyDlg->exec();
	 }
	 else 
	 {
        DirectQueryDlg *queryDlg = new DirectQueryDlg();
		queryDlg->exec();
     }	 
 }

 void IntroModeSelectDlg::clickCancel()
 {
	 reject();
 }
